-- CMD Monster Hunting v1.0
-- by DJ Command
-- 
-- http://cmdplus.tuzikaze.com/
-- http://www.s-a-r.jp/
-- dj-command@y3.dion.ne.jp

---------------- Initial Values ----------------
Triggers,GENEP,ENEMYS = {},{},{}
MAXENEMYS = 0
CollectionsUsed = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31}
------------------------------------------------
function PlayerProc()
	for P in Players() do
		if P.dead == false then SetItems(P) end
		for i = 0, 5 do
			P.overlays[i].text = " "
		end
		local target = P:find_target()
		if is_monster(target) then
			P._LOOKMONSTER = target
		else
			P._LOOKMONSTER = nil
		end
		if #Players == 1 then
			P.overlays[0].text = "Score : ".. P._SINGLEPOINTS
		else
			P.overlays[0].text = "Score : ".. P.points
		end
		if P._LOOKMONSTER ~= nil and P._LOOKMONSTER.player == nil then
			local l = math.floor((P._LOOKMONSTER.life / P._LOOKMONSTER._points)*20)
			local s = string.rep("#", l)
			s = s .. string.rep(".", 20-l)
			P.overlays[1].text = "Enemy : " .. s
			P.overlays[1].color = 2
		end
		if P._GETINTERVAL > 0 then
			P.overlays[2].text = "              Get " .. P._GETMSTRNAME
			P.overlays[2].color = 0
			P._GETINTERVAL = P._GETINTERVAL - 1
		end
		if P._COMBOINTERVAL > 0 then
			P.overlays[3].text = "                                      " .. P._COMBOCNT .. " Combos Bonus : " .. P._COMBOBONUS .. " Pts"
			P.overlays[3].color = 5
			P._COMBOINTERVAL = P._COMBOINTERVAL - 1
		end
	end
end


function DefineEnemys()
	for M in Monsters() do
		if M._defined == nil and M.player == nil then
			M.active = true
			M._defined = true
			M._points = M.life
			table.insert(ENEMYS, M)
			local optimalp = {}
			for i = 1, #GENEP do
				if (GENEP[i].ceiling.z - GENEP[i].floor.z) > M.type.height then
					table.insert(optimalp, GENEP[i])
				end
			end
			if #optimalp ~= 0 then
				local rp = 1 + Game.global_random(#optimalp)
				M:position(optimalp[rp].x, optimalp[rp].y, optimalp[rp].z, optimalp[rp])
			end
		end
	end
end


function GenerateEnemys()
	for i = 1, 10 do
		if #ENEMYS > MAXENEMYS then break end
		local rm = 1 + Game.global_random(46)
		Monsters.new(0, 0, Polygons[rm].floor.z, 0, rm)
	end
end


function CheckMonsters()
	DefineEnemys()
	local i = 1 
	while i <= #ENEMYS do
		if ENEMYS[i].valid == false or ENEMYS[i].life < 1 then
			table.remove(ENEMYS,i)
			i = i - 1
		end
		i = i + 1
	end
end


function SetItems(P)
	P.items["pistol"]									= 2
	P.items["pistol ammo"]						= 50
	P.items["fusion pistol"]					= 1
	P.items["fusion pistol ammo"]			= 25
	P.items["assault rifle"]					= 1
	P.items["assault rifle ammo"]			= 15
	P.items["assault rifle grenades"]	= 8
	P.items["missile launcher"]				= 1
	P.items["missile launcher ammo"]	= 4
	P.items["alien weapon"]						= 1
	P.items["alien weapon ammo"]			= 10
	P.items["flamethrower"]						= 1
	P.items["flamethrower ammo"]			= 3
	P.items["shotgun"]								= 2
	P.items["shotgun ammo"]						= 80
	P.items["smg"]										= 1
	P.items["smg ammo"]								= 8
end


function Triggers.init()
	for P in Players() do
		P._SINGLEPOINTS = 0
		P._GETMSTRNAME = " "
		P._GETINTERVAL = 0
		P._COMBOCNT = 0
		P._COMBOTIME = -150
		P._COMBOINTERVAL = 0
		P._COMBOBONUS = 0
		SetItems(P)
	end
	for G in Polygons() do
		if G.type ~= "monster impassable" and G.type ~= "platform" then
			table.insert(GENEP, G)
		end
	end
	MAXENEMYS = math.min(100, #GENEP) - #Players
	DefineEnemys()
end


function Triggers.idle()
	if Game.ticks % 30 == 0 then
		GenerateEnemys()
	end
	for I in Items() do
		I:delete()
	end
	CheckMonsters()
	PlayerProc()
end


function Triggers.player_revived(P)
	SetItems(P)
end


function Triggers.monster_killed(M, P)
	if P ~= nil then
		local i = math.floor(M._points / 10)
		P._GETMSTRNAME = M.type.mnemonic .. " : " .. i .. " PTS."
		if Game.ticks - P._COMBOTIME < 150 then
			P._COMBOCNT = P._COMBOCNT + 1
			P._COMBOTIME = Game.ticks
			P._COMBOINTERVAL = 150
			P._COMBOBONUS = P._COMBOBONUS + i
			i = i + P._COMBOBONUS
			P:play_sound("got powerup", 1)
		else
			P._COMBOCNT = 0
			P._COMBOBONUS = 0
			P:play_sound("get item", 1)
		end
		if #Players == 1 then
			P._SINGLEPOINTS = P._SINGLEPOINTS + i
		else
			P.points = P.points + i
		end
		P._COMBOTIME = Game.ticks
		P._GETINTERVAL = 30
		P.overlays[0].color = 1
	end
end


function Triggers.player_killed(P, agrs_player, action, projectile)
	if agrs_player ~= nil and agrs_player ~= P then
		agrs_player.points = agrs_player.points / 2
	end
end